
#ifndef SST_TST_ATP_SPECIAL_DATA_H
#define SST_TST_ATP_SPECIAL_DATA_H

#if TST_USE_SPECIAL_DATA_MODULE
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:06:34 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_ATP_SpecialData.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
/*Data operations test struct*/
typedef struct TST_ATP_SpecialDataOpAESTestDataStruct{  
    char              TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_AESKey[TST_AES_KEY_SIZE];
    DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_ChallengeBuffSize;
    DxByte_t                    TST_EncChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxByte_t                    TST_AuthenticatorAESKey[TST_AES_KEY_SIZE];
    SSTAESKeyType_t             TST_AESKeyType1;
    DxByte_t                    TST_AESKey2[TST_AES_KEY_SIZE];
    SSTAESKeyType_t             TST_AESKeyType2;
    DxByte_t                    TST_AESKeyTemp[TST_AES_KEY_SIZE];
    SSTAESKeyType_t             TST_AESKeyTypeTemp;
    DxUint32_t                  TST_KeySizeInBytes;
    CRYS_AES_IvCounter_t        TST_IVCounter;       
    CRYS_AES_OperationMode_t    TST_OperationMode;       
    DxUint8_t                   TST_DataIn[TST_MAX_DATA_VEC_SIZE_IN_BYTES];        
    DxUint32_t                  TST_DataInSize;         
    DxUint8_t                   TST_DataOut[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint8_t                   TST_DataOutDecrypt[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
} TST_ATP_SpecialDataOpAESTestDataStruct;

typedef struct TST_ATP_SpecialDataOpDESTestDataStruct{  
    char              TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_Password[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_PasswordSizeInBytes;
    DxUint32_t                  TST_MaxNumOfTrials;
    DxByte_t                    TST_DESKey1[TST_AES_KEY_SIZE];
    SSTDESKeyType_t             TST_DESKeyType1;
    DxByte_t                    TST_DESKey2[TST_AES_KEY_SIZE];
    SSTDESKeyType_t             TST_DESKeyType2;
    DxByte_t                    TST_DESKeyTemp[TST_AES_KEY_SIZE];
    SSTDESKeyType_t             TST_DESKeyTypeTemp;
    DxUint32_t                  TST_KeySizeInBytes;
    CRYS_DES_Iv_t               TST_IVCounter;       
    CRYS_DES_OperationMode_t    TST_OperationMode;       
    DxUint8_t                   TST_DataIn[TST_MAX_DATA_VEC_SIZE_IN_BYTES];        
    DxUint32_t                  TST_DataInSize;         
    DxUint8_t                   TST_DataOut[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint8_t                   TST_DataOutDecrypt[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
} TST_ATP_SpecialDataOpDESTestDataStruct;

typedef struct TST_ATP_SpecialDataOpHMACTestDataStruct{  
    char              TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_Password[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_PasswordSizeInBytes;
    DxUint32_t                  TST_MaxNumOfTrials;
    DxByte_t                    TST_HMACKey1[TST_HMAC_KEY_SIZE];
    DxUint32_t                  TST_HMACKey1Size;
    DxByte_t                    TST_HMACKey2[TST_HMAC_KEY_SIZE];
    DxUint32_t                  TST_HMACKey2Size;
    DxByte_t                    TST_HMACKeyTemp[TST_HMAC_KEY_SIZE];
    DxUint32_t                  TST_HMACKeyTempSize;  
    CRYS_HASH_OperationMode_t   TST_OperationMode;       
    DxUint8_t                   TST_DataIn[TST_MAX_DATA_VEC_SIZE_IN_BYTES];        
    DxUint32_t                  TST_DataInSize;         
    CRYS_HASH_Result_t          TST_DataHMAC_Result1;
    CRYS_HASH_Result_t          TST_DataHMAC_Result2;
    DxUint32_t                  TST_HASHSize;
} TST_ATP_SpecialDataOpHMACTestDataStruct;

typedef struct TST_ATP_SpecialDataOpRSATestDataStruct{  
    char              TST_Name[TST_NAME_STRING_LEN];
    /*Challenge key*/
    DxUint32_t                  TST_ChalengeKeySizeInBytes;
    DxByte_t                    TST_N[TST_N_SIZE_BYTES];
    DxByte_t                    TST_D[TST_N_SIZE_BYTES];
    DxByte_t                    TST_E[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_ChalengeKeyESizeInBytes;
    DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_ChallengeBuffSize;  
    DxByte_t                    TST_SignedChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_SignedChallengeBuffSize; 
    /*Key Creation parameters for Keys 1 and 2 */
    DxUint32_t                  TST_Key1SizeInBytes;
    DxByte_t                    TST_E1[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_E1SizeInBytes;
    /* Key info buffers for keys 3 and 4 */
    DxByte_t                    TST_N3[TST_N_SIZE_BYTES];
    DxUint32_t                  TST_N3SizeInBytes;
    DxByte_t                    TST_D3[TST_D_SIZE_BYTES];
    DxUint32_t                  TST_D3SizeInBytes;
    DxByte_t                    TST_E3[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_E3SizeInBytes;
    DxByte_t                    TST_N4[TST_N_SIZE_BYTES];
    DxUint32_t                  TST_N4SizeInBytes;
    DxByte_t                    TST_D4[TST_D_SIZE_BYTES]; 
    DxUint32_t                  TST_D4SizeInBytes;
    DxByte_t                    TST_E4[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_E4SizeInBytes;
    DxByte_t                    TST_P4[TST_P_SIZE_BYTES];
    DxUint32_t                  TST_P4SizeInBytes;
    DxByte_t                    TST_Q4[TST_Q_SIZE_BYTES];
    DxUint32_t                  TST_Q4SizeInBytes;
    DxByte_t                    TST_DP4[TST_DP_SIZE_BYTES];
    DxUint32_t                  TST_DP4SizeInBytes;
    DxByte_t                    TST_DQ4[TST_DQ_SIZE_BYTES];
    DxUint32_t                  TST_DQ4SizeInBytes;
    DxByte_t                    TST_Qinv4[TST_QINV_SIZE_BYTES];
    DxUint32_t                  TST_Qinv4SizeInBytes;
    /* Key info buffers for keys 5 and 6 */
    DxByte_t                    TST_N5[TST_N_SIZE_BYTES];
    DxByte_t                    TST_D5[TST_D_SIZE_BYTES];
    DxByte_t                    TST_E5[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_E5SizeInBytes;
    DxUint32_t                  TST_Key5SizeInBytes;
    DxByte_t                    TST_P5[TST_P_SIZE_BYTES];
    DxByte_t                    TST_Q5[TST_Q_SIZE_BYTES];
    DxByte_t                    TST_DP5[TST_DP_SIZE_BYTES];
    DxByte_t                    TST_DQ5[TST_DQ_SIZE_BYTES];
    DxByte_t                    TST_Qinv5[TST_QINV_SIZE_BYTES];
    /*Data*/ 
    DxByte_t                    TST_DataIn[TST_MAX_DATA_VEC_SIZE_IN_BYTES];        
    DxUint32_t                  TST_DataInSize; 
    DxByte_t                    TST_DataOut[TST_MAX_DATA_VEC_SIZE_IN_BYTES];        
    DxUint16_t                  TST_DataOutSize;
    CRYS_RSA_HASH_OpMode_t    TST_HASHOperationMode;
    DxUint16_t                  TST_SaltLengthSign;
    DxUint16_t                  TST_SaltLengthVerify;
} TST_ATP_SpecialDataOpRSATestDataStruct;



/************************ Public Variables **********************/
/************************ Public Functions **********************/
/*****************************************************************************
* Function Name:                                                           
*  SST_TST_ATP_SpecialDataOpAES        
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
* Test the Test the insertion, generation, reading, deletion, and usage of an AES symmetric key.
*  
* Algorithm:       
*    1.    Create a new session by calling: SST_SessionCreate.
*    2.    Open a transaction by calling: SST_TransactionStart.
*    3.    Create a new AES shared key authenticator by calling: SST_ AuthenticatorAESSharedSecretCreate.
*    4.    Open the authenticator by calling:
*          i.      SST_AuthenticatorChallengeGet 
*          ii.      CRYS_AES (Encrypt the challenge using the AES key)
*          iii.  SST_AuthenticationOpen.
*    5.  Close the transaction by calling: SST_TransactionClose.
*    6.  Open a transaction by calling: SST_TransactionStart.
*    7.  Create a new AES #1 key by calling: SST_AESKeyGenerate.
*    8.  Read the generated AES key #1 by calling: SST_AESKeyRead.
*    9.  Insert an AES #2 key to the SST by calling: SST_AESKeyInsert. Using the data received by reading the SST key #1
*    10.  Read the inserted AES key #2 by calling: SST_AESKeyRead. And compare to data used.
*    11.  Close the transaction by calling: SST_TransactionEnd.
*    12.  Encrypt plain text by using AES key #1 and calling: CRYS_SST_AES.
*    13.  Decrypt the received cipher text using AES key #2 by calling: CRYS_SST_AES and compare to the original plain text.
*    14.  Open a transaction by calling: SST_TransactionStart.
*    15.  Delete the AES keys (one by one) by calling: SST_DataDelete.
*    16.  Close the authenticator by calling: SST_AuthenticationClose.
*    17.  Delete the authenticator by calling: SST_AuthenticatorDelete.
*    18.  Close the transaction by calling: SST_TransactionClose.
*    19.  Delete the session by calling: SST_SessionDelete.
*
*******************************************************************************/ 
DxError_t SST_TST_ATP_SpecialDataOpAES ( void );
/*****************************************************************************
* Function Name:                                                           
*  SST_TST_ATP_SpecialDataOpDES        
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
* Test the Test the insertion, generation, reading, deletion, and usage of a DES symmetric key.
*  
* Algorithm:       
*    1.  Create a new session by calling: SST_SessionCreate.
*    2.  Open a transaction by calling: SST_TransactionStart.
*    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
*    4.  Close the transaction by calling: SST_TransactionEnd.
*    5.  Open the authenticator by calling: SST_AuthenticationOpen.
*    6.  Open a transaction by calling: SST_TransactionStart.
*    7.  Create a new DES #1 key by calling: SST_DESKeyGenerate.
*    8.  Read the generated DES key #1 by calling: SST_DESKeyRead.
*    9.  Insert a DES #2 key to the SST by calling: SST_DESKeyInsert. Using the data received by reading the SST key #1
*    10.  Read the inserted DES key #2 by calling: SST_DESKeyRead. And compare to data used.
*    11.  Close the transaction by calling: SST_TransactionEnd.
*    12.  Encrypt plain text by using DES key #1 and calling: CRYS_SST_DES.
*    13.  Decrypt the received cipher text using DES key #2 by calling: CRYS_SST_DES and compare to the original plain text.
*    14.  Open a transaction by calling: SST_TransactionStart.
*    15.  Delete the DES keys (one by one) by calling: SST_DataDelete.
*    16.  Close the authenticator by calling: SST_AuthenticationClose.
*    17.  Delete the authenticator by calling: SST_AuthenticatorDelete.
*    18.  Close the transaction by calling: SST_TransactionClose.
*    19.  Delete the session by calling: SST_SessionDelete.
*
*******************************************************************************/ 
DxError_t SST_TST_ATP_SpecialDataOpDES ( void );
/*****************************************************************************
* Function Name:                                                           
*  SST_TST_ATP_SpecialDataOpHMAC        
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
* Test the Test the insertion, generation, reading, deletion, and usage of a HMAC key.
*  
* Algorithm:       
*    1.  Create a new session by calling: SST_SessionCreate.
*    2.  Open a transaction by calling: SST_TransactionStart.
*    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
*    4.  Close the transaction by calling: SST_TransactionClose.
*    5.  Open the authenticator by calling: SST_AuthenticationOpen.
*    6.  Open a transaction by calling: SST_TransactionStart.
*    7.  Create a new HMAC #1 key by calling: SST_HMACKeyGenerate.
*    8.  Read the generated HMAC key #1 by calling: SST_HMACKeyRead.
*    9.  Insert a HMAC #2 key to the SST by calling: SST_HMACKeyInsert. Using the data received by reading the SST key #1
*    10.  Read the inserted HMAC key #2 by calling: SST_HMACKeyRead. And compare to data used.
*    11.  Close the transaction by calling: SST_TransactionEnd.
*    12.  Hash plain text by using HMAC key #1 and calling: CRYS_SST_HMAC.
*    13.  Hash the received cipher text using HMAC key #2 by calling: CRYS_SST_HMAC and compare to the original hash result.
*    14.  Open a transaction by calling: SST_TransactionStart.
*    15.  Delete the HMAC keys (one by one) by calling: SST_DataDelete.
*    16.  Close the authenticator by calling: SST_AuthenticationClose.
*    17.  Delete the authenticator by calling: SST_AuthenticatorDelete.
*    18.  Close the transaction by calling: SST_TransactionClose.
*    19.  Delete the session by calling: SST_SessionDelete.                             
*
*******************************************************************************/ 
DxError_t SST_TST_ATP_SpecialDataOpHMAC ( void );
/*****************************************************************************
* Function Name:                                                           
*  SST_TST_ATP_SpecialDataOpRSA      
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
* Test the Test the insertion, generation, reading, deletion, and usage of a RSA asymmetric key.
*  
* Algorithm:       
*     1.  Build a Private Key using CRYS for CRYS usage by calling: CRYS_RSA_Build_PrivKey (externally generated key).
*     2.  Create a new session by calling: SST_SessionCreate.
*     3.  Open a transaction by calling: SST_TransactionStart.
*     4.  Create a public key authenticator by calling: SST_AuthenticatorPubKeyRSACreate.
*     5.  Open the authenticator by calling:
*     i.  SST_AuthenticatorChallengeGet 
*         ii.  CRYS_RSA_PSS_Sign
*         iii.  SST_AuthenticationOpen.
*     6.  Close the transaction by calling: SST_TransactionClose.
*     7.  Open the authenticator by calling: SST_AuthenticationOpen.
*     8.  Create a new RSA #1 key by calling: SST_RSAKeyGenerate.
*     9.  Create a new RSA #2 key by calling: SST_CRTRSAKeyGenerate.
*     10.  Read the generated RSA key #1 by calling: 
*          i.  SST_RSAPublicKeyRead.
*          ii.  SST_RSAPrivateKeyRead.
*     11.  Read the generated RSA key #2 by calling: 
*          i.  SST_CRTRSAPublicKeyRead.
*          ii.  SST_CRTRSAPrivateKeyRead.
*     12.  Insert an RSA #3 key to the SST by calling:
*          i.   SST_RSAPublicKeyInsert. 
*          ii.  SST_RSAPrivateKeyInsert
*          Using the data received by reading the SST key #1
*     13.  Insert an RSA #4 key to the SST by calling:
*          i.   SST_CRTRSAPublicKeyInsert.
*          ii.  SST_CRTRSAPrivateKeyInsert
*          Using the data received by reading the SST key #2
*     14.  Insert RSA #5 key to the SST by calling: SST_RSAPairKeyInsert. Externally generated key pair
*     15.  Insert RSA #6 (CRT) key to the SST by calling SST_CRTRSAPairKeyInsert. Externally generated key pair
*     16.  Close the transaction by calling: SST_TransactionClose.
*     17.  Sign a plain text by using RSA key #1 and calling: CRYS_SST_RSA_PKCS1v15_Sign.
*     18.  Verify the signature using RSA key #3 and calling: CRYS_SST_RSA_PKCS1v15_Verify.
*     19.  Sign a plain text by using RSA key #2 and calling: CRYS_SST_RSA_PSS_Sign.
*     20.  Verify the signature using RSA key #4 and calling: CRYS_SST_RSA_PSS_Verify.
*     21.  Sign a plain text by using RSA key #5 and calling: CRYS_SST_RSA_PKCS1v15_Sign.
*     22.  Verify the signature using RSA key #6 and calling: CRYS_SST_RSA_PKCS1v15_Verify.
*     23.  Sign a plain text by using RSA key #5 and calling: CRYS_SST_RSA_PSS_Sign.
*     24.  Verify the signature using RSA key #6 and calling: CRYS_SST_RSA_PSS_Verify.
*     25.  Open a transaction by calling: SST_TransactionStart.
*     26.  Delete the RSA keys (one by one) by calling: SST_DataDelete.
*     27.  Close the authenticator by calling: SST_AuthenticationClose.
*     28.  Delete the authenticator by calling: SST_AuthenticatorDelete.
*     29.  Close the transaction by calling: SST_TransactionClose.
*     30.  Delete the session by calling: SST_SessionDelete.
*
*******************************************************************************/    
DxError_t SST_TST_ATP_SpecialDataOpRSA ( void );

#ifdef __cplusplus
}
#endif

#endif

#endif

